% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch03CTT.R
\name{OmegaCoefficient}
\alias{OmegaCoefficient}
\title{Omega Coefficient}
\usage{
OmegaCoefficient(x, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{x}{This should be a data matrix or a Covariance/Phi/Tetrachoric matrix.}

\item{na}{This parameter identifies the numbers or characters that should be treated as missing values when 'x' is a data matrix.}

\item{Z}{This parameter represents a missing indicator matrix. It is only needed if 'x' is a data matrix.}

\item{w}{This parameter is an item weight vector. It is only required if 'x' is a data matrix.}
}
\value{
For a correlation/covariance matrix input, returns a single numeric value
representing the omega coefficient. For a data matrix input, returns a list with
three components:
\itemize{
\item OmegaCov: Omega coefficient calculated from covariance matrix
\item OmegaPhi: Omega coefficient calculated from phi coefficient matrix
\item OmegaTetrachoric: Omega coefficient calculated from tetrachoric correlation matrix
}
}
\description{
This function computes Tau-Congeneric Measurement, also known as McDonald's tau coefficient, for a given data set.
}
\references{
McDonald, R. P. (1999). Test theory: A unified treatment. Erlbaum.
}
