% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operating_characteristics.R
\name{optimal_mtd}
\alias{optimal_mtd}
\title{Percent of doses in relation the optimal MTD interval}
\usage{
optimal_mtd(dose_matrix, true_mtd, margin, digits = 2)
}
\arguments{
\item{dose_matrix}{a numerical matrix of assigned doses for each step of the trial (column)
and for each trial (row).}

\item{true_mtd}{a numerical value of the true Maximum Tolerable Dose.}

\item{margin}{a numerical value of the acceptable margin of distance from the
\code{true_MTD}.}

\item{digits}{a numerical value indicating the number of digits.}
}
\value{
\code{interval} the average percent of doses which are inside the optimal MTD interval.

\code{underdose} the average percent of doses which are smaller than the lower limit of the optimal MTD interval.

\code{overdose} the average percent of doses which are greater than the upper limit of the optimal MTD interval.
}
\description{
Calculate the percent of dose which are inside the optimal MTD interval \code{[true_MTD -
margin ; true_MTD + margin]}.
}
\examples{
\dontshow{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 1, sample_size = 2,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       ncores = 2)
optimal_mtd(sim$mtd_sim, true_mtd = 20, margin = 0.1*20)
optimal_mtd(sim$dose_sim, true_mtd = 20, margin = 0.1*20)
}

\dontrun{
DLT <- 0
dose <- 30
step_zero <- ewoc_d1classic(DLT ~ dose, type = 'discrete',
                           theta = 0.33, alpha = 0.25,
                           min_dose = 0, max_dose = 100,
                           dose_set = seq(0, 100, 20),
                           rho_prior = matrix(1, ncol = 2, nrow = 1),
                           mtd_prior = matrix(1, ncol = 2, nrow = 1),
                           rounding = "nearest")
response_sim <- response_d1classic(rho = 0.05, mtd = 20, theta = 0.33,
                                  min_dose = 10, max_dose = 50)
sim <- ewoc_simulation(step_zero = step_zero,
                       n_sim = 2, sample_size = 30,
                       alpha_strategy = "increasing",
                       response_sim = response_sim,
                       ncores = 2)
optimal_mtd(sim$mtd_sim, true_mtd = 20, margin = 0.1*20)
optimal_mtd(sim$dose_sim, true_mtd = 20, margin = 0.1*20)
}

}
