% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended_ewoc.R
\name{ewoc_d1extended}
\alias{ewoc_d1extended}
\title{Escalation With Overdose Control}
\usage{
ewoc_d1extended(formula, theta, alpha, rho_prior, min_dose, max_dose,
  type = c("continuous", "discrete"), first_dose = NULL, last_dose = NULL,
  dose_set = NULL, max_increment = NULL, rounding = c("down", "nearest"),
  n_adapt = 5000, burn_in = 1000, n_mcmc = 1000, n_thin = 1,
  n_chains = 1)
}
\arguments{
\item{formula}{an object of class \code{\link[Formula]{Formula}}: a symbolic
description of the model to be fitted with only one regressor term
corresponding to the dose for the right side and a numeric vector as a response
containing number of DLT for the left side.}

\item{theta}{a numerical value defining the proportion of expected patients
to experience a medically unacceptable, dose-limiting toxicity (DLT) if
administered the MTD.}

\item{alpha}{a numerical value defining the probability that the dose selected
by EWOC is higher than the MTD.}

\item{rho_prior}{a matrix 3 x 2 of hyperparameters for the Beta prior
distribution associated with each parameter rho. Each row corresponds to a parameter.}

\item{min_dose}{a numerical value defining the lower bound of the support of
the MTD.}

\item{max_dose}{a numerical value defining the upper bound of the support of
the MTD.}

\item{type}{a character describing the type of the Maximum Tolerable Dose
(MTD) variable.}

\item{first_dose}{a numerical value for the first allowable dose in the trial.}

\item{last_dose}{a numerical value for the last allowable dose in the trial.}

\item{dose_set}{a numerical vector of allowable doses in the trial. It is only
necessary if type = "discrete".}

\item{max_increment}{a numerical value indicating the maximum increment from the current dose to the next dose.}

\item{rounding}{a character indicating how to round a continuous dose to the
one of elements of the dose set.
It is only necessary if type = "discrete".}

\item{n_adapt}{the number of iterations for adaptation.
See \code{\link[rjags]{adapt}} for details.}

\item{burn_in}{the number of iterations before to start monitoring.}

\item{n_mcmc}{the number of iterations to monitor.}

\item{n_thin}{thinning interval for monitors.}

\item{n_chains}{the number of parallel chains for the model.}
}
\value{
\code{next_dose} the next recommend dose.

\code{mtd} a numerical vector for the posterior MTD distribution considering the next patient covariable.

\code{rho} a matrix for the posterior rho_0 and rho_1 distributions.

\code{sample} a list of the MCMC chains distribution.

\code{trial} a list of the trial conditions.
}
\description{
Finding the next dose for a phase I clinical trial based on the
Escalation with Overdose Control (EWOC) design considering the
extended parametrization for binary response and single agent.
}
\examples{
DLT <- 0
dose <- 30

test <- ewoc_d1extended(DLT ~ dose, type = 'discrete',
                       theta = 0.33, alpha = 0.25,
                       dose_set = c(30, 40, 50),
                       min_dose = 20, max_dose = 100,
                       rho_prior = matrix(1, ncol = 2, nrow = 2),
                       rounding = "nearest")
summary(test)
plot(test)

}
