% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_contour.R
\name{pl_contour}
\alias{pl_contour}
\title{Contour function of a Gaussian random fuzzy number}
\usage{
pl_contour(x, GRFN)
}
\arguments{
\item{x}{The input value (can be a vector).}

\item{GRFN}{A Gaussian random fuzzy number, encoded as a list with components mu, sig
and h.}
}
\value{
The degree of plausibility of x.
}
\description{
\code{pl_contour} computes the degree of plausibility of any number x for a given Gaussian
random fuzzy number.
}
\details{
cont(x,GRFN) returns the same value as Pl(x,x,GRFN), but is more efficient.
}
\examples{
pl<-pl_contour(1,list(mu=2,sig=1,h=2))
print(pl)
}
\references{
Thierry Denoeux. Reasoning with fuzzy and uncertain evidence using epistemic random
fuzzy sets: general framework and practical models. Fuzzy Sets and Systems, Vol. 453,
Pages 1-36, 2023.
}
\seealso{
\code{\link{Pl}}, \code{\link{Bel}}, \code{\link{Belint}}
}
