% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootstrapRep.R
\name{BootstrapStat}
\alias{BootstrapStat}
\title{Non-Parametric population samples and statistic comparison}
\usage{
BootstrapStat(
  ind.data,
  iterations,
  ComparisonFunc,
  StatFunc,
  sample.size = dim(ind.data)[1],
  parallel = FALSE
)
}
\arguments{
\item{ind.data}{Matrix of residuals or indiviual measurments}

\item{iterations}{Number of resamples to take}

\item{ComparisonFunc}{comparison function}

\item{StatFunc}{Function for calculating the statistic}

\item{sample.size}{Size of ressamples, default is the same size as ind.data}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
returns the mean repeatability, that is, the mean value of comparisons from samples to original statistic.
}
\description{
Random populations are generated via ressampling 
using the suplied population. A statistic is calculated on the
random population and compared to the statistic calculated on the
original population.
}
\examples{
cov.matrix <- RandomMatrix(5, 1, 1, 10)

BootstrapStat(iris[,1:4], iterations = 50,
               ComparisonFunc = function(x, y) PCAsimilarity(x, y)[1],
               StatFunc = cov)

#Calculating R2 confidence intervals
r2.dist <- BootstrapR2(iris[,1:4], 30)
quantile(r2.dist)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#BootstrapStat(iris[,1:4], iterations = 100,
#               ComparisonFunc = function(x, y) KrzCor(x, y)[1],
#               StatFunc = cov,
#               parallel = TRUE)
}
\seealso{
\code{\link{BootstrapRep}}, \code{\link{AlphaRep}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{montecarlo}
\keyword{parametricsampling}
\keyword{repeatability}
