% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtendMatrix.R
\name{ExtendMatrix}
\alias{ExtendMatrix}
\title{Control Inverse matrix noise with Extension}
\usage{
ExtendMatrix(cov.matrix, var.cut.off = 1e-04, ret.dim = NULL)
}
\arguments{
\item{cov.matrix}{Covariance matrix}

\item{var.cut.off}{Cut off for second derivative variance. Ignored if ret.dim is passed.}

\item{ret.dim}{Number of retained eigen values}
}
\value{
Extended covariance matrix and second derivative variance
}
\description{
Calculates the extented covariance matrix estimation as described in Marroig et al. 2012
}
\note{
Covariance matrix being extended should be larger then 10x10
}
\examples{
cov.matrix = RandomMatrix(11, 1, 1, 100)
ext.matrix = ExtendMatrix(cov.matrix, var.cut.off = 1e-6)
ext.matrix = ExtendMatrix(cov.matrix, ret.dim = 6)
}
\references{
Marroig, G., Melo, D. A. R., and Garcia, G. (2012). Modularity, noise, and natural selection. Evolution; international journal of organic evolution, 66(5), 1506-24. doi:10.1111/j.1558-5646.2011.01555.x
}
\author{
Diogo Melo
}
\keyword{covariancematrix}
\keyword{extension}
