% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_extractor.R
\name{coefficient_extractor}
\alias{coefficient_extractor}
\title{Bootstrap coefficient extractor}
\usage{
coefficient_extractor(object, ...)
}
\arguments{
\item{object}{a fitted model with bootstraps of class evzinb, evinb, nbboot, or zinbboot}

\item{...}{Component to be extracted (not for nbboot). Alternatives are 'nb','zi','evinf','pareto', and 'all'}
}
\value{
A tibble with coefficient values, one row per bootstrap and component
}
\description{
Bootstrap coefficient extractor
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps = 10, multicore = TRUE, ncores = 2)
coefficient_extractor(model, component = 'all')

}
