% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_extractor.R
\name{coefficient_extractor.zinbboot}
\alias{coefficient_extractor.zinbboot}
\title{Bootstrap coefficient extractor}
\usage{
\method{coefficient_extractor}{zinbboot}(object, component = c("nb", "zi", "all"), ...)
}
\arguments{
\item{object}{A fitted evinb model with bootstraps}

\item{component}{Which component should be extracted}

\item{...}{Not in use}
}
\value{
A tibble with coefficient values, one row per bootstrap and component
}
\description{
Bootstrap coefficient extractor
}
\examples{
data(genevzinb2)
model <- evzinb(y~x1+x2+x3,data=genevzinb2, n_bootstraps=10)
zinb_comp <- compare_models(model)
coefficient_extractor(zinb_comp$zinb)

}
