% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{simulate.evgam}
\alias{simulate.evgam}
\title{Simulations from a fitted \code{evgam} object}
\usage{
\method{simulate}{evgam}(
  object,
  nsim = 1000,
  seed = NULL,
  newdata = NULL,
  type = "link",
  probs = NULL,
  threshold = 0,
  marginal = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted \code{evgam} object}

\item{nsim}{an integer giving the number of simulations}

\item{seed}{an integer giving the seed for simulations}

\item{newdata}{a data frame}

\item{type}{a character string, as in \code{predict.evgam}; defaults to \code{"quantile"}}

\item{probs}{a scalar or vector of probabilities for quantiles; defaults to NULL}

\item{threshold}{a scalar, vector or matrix, which is added to each simulation if \code{family == "gpd"}; defaults to 0}

\item{marginal}{a logical: should simulations integrate out smoothing parameter uncertainty? Defaults to TRUE}

\item{...}{arguments to be passed to \code{predict.evgam}}
}
\value{
Simulations of parameters or quantiles
}
\description{
Simulations from a fitted \code{evgam} object
}
\examples{

\donttest{

library(evgam)
data(COprcp)
COprcp$year <- format(COprcp$date, "\%Y")
COprcp_gev <- aggregate(prcp ~ year + meta_row, COprcp, max)
COprcp_gev <- cbind(COprcp_gev, COprcp_meta[COprcp_gev$meta_row,])
fmla_gev <- list(prcp ~ s(lon, lat, k=30) + s(elev, bs="cr"), ~ s(lon, lat, k=20), ~ 1)
m_gev <- evgam(fmla_gev, data=COprcp_gev, family="gev")
simulate(m_gev)
simulate(m_gev, probs=c(.95, .99))

}

}
\seealso{
\link{predict.evgam}
}
