% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_latent_trawl.R
\name{TrawlExp}
\alias{TrawlExp}
\title{Returns an exponential trawl function with base time t.}
\usage{
TrawlExp(t, rho, max_value = 1, min_value = 0.01)
}
\arguments{
\item{t}{trawl function peak time.}

\item{rho}{exponential trawl parameter. Should be positive.}

\item{max_value}{Miximal value of the trawl function (if known). Default 1.}

\item{min_value}{Minimal value accepted for the trawl function. Default is
1e-2.}
}
\value{
(Vectorised) Exponential trawl function with peak time t and
  parameter rho. If this function is evaluated using NA, it yields a list of
  key components (rho, max time difference, total area of trawl set A).
}
\description{
Returns an exponential trawl function with base time t.
}
