% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inventory.R
\name{check_inventory}
\alias{check_inventory}
\title{Perform some checks on the inventory}
\usage{
check_inventory(data_inventory, check_hist = FALSE, check_vars = FALSE)
}
\arguments{
\item{data_inventory}{A data.table as resulting from
\code{\link{get_inventory}}.}

\item{check_hist}{Boolean, if \code{TRUE}, tests that each rcp* has a corresponding historical run.}

\item{check_vars}{Boolean, if \code{TRUE}, runs \code{\link{compare_variables_in_inventory}}
to check if all variables are available in all models.}
}
\value{
An object of class "eurocordexr_inv_check" (an overloaded list) with results
from the checks. Has a special print method, which shows a verbose summary of the results.
}
\description{
Some simple checks for multiple time frequencies, domains, ensembles,
downscale realizations, and completeness of simulation periods.
Can also run \code{\link{compare_variables_in_inventory}}
to check for completeness of variables for all models. These checks are meant
as guides only, since one might not wish multiple elements of the above for
climate model ensemble assessments.
}
\details{
The checks are \itemize{
\item for multiple time frequency (day, month, ...)
\item for multiple domains (EUR-11, EUR-44, ...)
\item for multiple ensembles (r1i1p1, r2i1p1, ...)
\item for multiple downscale realizations (v1, v2, ..)
\item for complete periods of simulations: historical usually goes approx.
from 1950/70 - 2005, and rcp* from 2006 - 2100; evaluation is not checked,
because it has very heterogeneous periods; cordex-adjust has historical and
rcp* combined
\item that each rcp* has a corresponding historical run (optional, off by
default; otherwise problematic with merged hist and rcp runs, as in cordex-adjust)
\item that all variables (tas, pr, ...) are available for all models (optional, off by default)
}
}
\examples{
# some empty example files
fn_zip <- system.file("extdata", "inv-test-files.zip", package = "eurocordexr")
tmpdir <- tempdir()
unzip(fn_zip, exdir = tmpdir)

dat_inv <- get_inventory(fs::path(tmpdir, "testdata"))
check_inventory(dat_inv)

}
