% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_market_model.R
\name{returns}
\alias{returns}
\title{Constructor of an object of S3 class \code{returns}.}
\usage{
returns(rates, regressor, market_model = c("mean_adj", "mrkt_adj",
  "sim"), estimation_method = c("ols"), estimation_start, estimation_end)
}
\arguments{
\item{rates}{an object of class either \code{zoo} or \code{data.frame}
giving observed rates of returns of security.}

\item{regressor}{an object of the same class as \code{rates} representing
rates of returns of the market model, if needed.}

\item{market_model}{a character indicating the market model among
\code{mean_adj}, \code{mrkt_adj}, and \code{sim}.}

\item{estimation_method}{a character specifying an estimation method for
\code{sim} model.}

\item{estimation_start}{an object of \code{Date} class giving the first date
of the estimation period.}

\item{estimation_end}{an object of \code{Date} class giving the last date of
the estimation period.}
}
\value{
An object of S3 class \code{returns}, which contains following
fields:
\itemize{
\item observed: an object of \code{zoo} class containing observed rates of
returns.
\item predicted: an object of \code{zoo} class containing predicted by a
market model rates of returns.
\item lower95CI: a lower bound of the 95\% Confidence Interval for
predicted rates of returns.
\item upper95CI: an upper bound of the 95\% Confidence Interval for
predicted rates of returns.
\item abnormal: an object of \code{zoo} class containing abnormal returns.
\item regressor: an object of \code{zoo} class containing rates of
regressor (typically market index).
\item market_model: a code name of the market model.
\item full_name_market_model: a full name of the market model.
\item estimation_method: a code name of the estimation method (applied only
for SIM).
\item full_name_estimation_method: a full name of the estimation method
(applied only for SIM).
\item coefficients: coefficients \eqn{\alpha} and \eqn{\beta} for SIM market
model (applied only for SIM).
\item estimation_start: a start date of the estimation period.
\item estimation_end: an end date of the estimation period.
\item estimation_length: a length of the estimation period.
}
}
\description{
Constructs an object of S3 class \code{returns}.
}
\details{
The constructor is a generic function, dispatched for classes \code{zoo}
\code{data.frame}. Parameters \code{rates} and \code{regressor} should be
objects of the same class (\code{zoo} or \code{data.frame}). There are three
market model implemented. \code{mean_adj} stands for mean-adjusted-returns
model, which is the average of returns during the estimation period.
\code{mrkt_adj} represents market-adjusted-returns model: the securities'
rates of returns are simply market index rates of returns (in terms of
parameters - \code{regressor}). Finally, \code{sim} stands for single-index
market model For this model only Ordinary Least Squares
\code{estimation_method} is currently implemented. All models are described
in Brown and Warner (1985).
}
\examples{
library("zoo")
## 1. Mean-adjusted-returns model
\dontrun{
library("magrittr")
single_return <- get_prices_from_tickers("ALV.DE",
                                         start = as.Date("2000-01-01"),
                                         end = as.Date("2002-01-01"),
                                         quote = "Close",
                                         retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    returns(market_model = "mean_adj",
            estimation_start = as.Date("2001-03-26"),
            estimation_end = as.Date("2001-09-10"))
}
## The result of the code above is equivalent to:
data(rates)
single_return <- returns(rates[, "ALV.DE"],
                         market_model = "mean_adj",
                         estimation_start = as.Date("2001-03-26"),
                         estimation_end = as.Date("2001-09-10"))

## 2. Market-adjusted-returns model
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")

single_return <- get_prices_from_tickers("ALV.DE",
                                         start = as.Date("2000-01-01"),
                                         end = as.Date("2002-01-01"),
                                         quote = "Close",
                                         retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    returns(regressor = rates_indx,
            market_model = "mrkt_adj",
            estimation_start = as.Date("2001-03-26"),
            estimation_end = as.Date("2001-09-10"))
}
## The result of the code above is equivalent to:
data(rates, rates_indx)
single_return <- returns(rates = rates[, "ALV.DE", drop = FALSE],
                         regressor = rates_indx,
                         market_model = "mrkt_adj",
                         estimation_method = "ols",
                         estimation_start = as.Date("2001-03-26"),
                         estimation_end = as.Date("2001-09-10"))

## 3. Single-index market model
\dontrun{
library("magrittr")
rates_indx <- get_prices_from_tickers("^STOXX50E",
                                      start = as.Date("2000-01-01"),
                                      end = as.Date("2002-01-01"),
                                      quote = "Close",
                                      retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous")

single_return <- get_prices_from_tickers("ALV.DE",
                                         start = as.Date("2000-01-01"),
                                         end = as.Date("2002-01-01"),
                                         quote = "Close",
                                         retclass = "zoo") \%>\%
    get_rates_from_prices(quote = "Close",
                          multi_day = TRUE,
                          compounding = "continuous") \%>\%
    returns(regressor = rates_indx,
            market_model = "sim",
            estimation_method = "ols",
            estimation_start = as.Date("2001-03-26"),
            estimation_end = as.Date("2001-09-10"))
}
## The result of the code above is equivalent to:
data(rates, rates_indx)
single_return <- returns(rates = rates[, "ALV.DE", drop = FALSE],
                         regressor = rates_indx,
                         market_model = "sim",
                         estimation_method = "ols",
                         estimation_start = as.Date("2001-03-26"),
                         estimation_end = as.Date("2001-09-10"))

}
\references{
Brown S.J., Warner J.B. \emph{Using Daily Stock Returns, The Case
of Event Studies}. Journal of Financial Economics, 14:3-31, 1985.
}
\seealso{
\code{\link{apply_market_model}}
}
