% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{get_SE.mln.mean.sd}
\alias{get_SE.mln.mean.sd}
\title{Parametric bootstrap standard error estimation for the method for unknown non-normal distributions approach}
\usage{
\method{get_SE}{mln.mean.sd}(x, nboot = 1000, shift.when.negative = TRUE, shift.val = 0.5, ...)
}
\arguments{
\item{x}{object of class "mln.mean.sd".}

\item{nboot}{numeric value giving the number of bootstrap replicates. The default is \code{1000}.}

\item{shift.when.negative}{logical scalar indicating whether to add a constant to the generated sample quantiles if the smallest quantile (i.e., the minimum value in scenarios S1 and S3, the first quartile in scenario S2) is negative. When this argument is set to \code{TRUE}, a constant is added such that the smallest quantile equals \code{shift.val}. The default is \code{TRUE}.}

\item{shift.val}{numeric value to which the smallest quantile should be shifted to if it is negative (see argument \code{shift.when.negative}). This argument is only applicable when \code{shift.when.negative} is set to \code{TRUE}. The default is \code{0.5}.}

\item{...}{other arguments.}
}
\value{
A list with the following components:
\item{est.se}{Estimated standard error of the mean estimator.}
\item{boot.means}{Bootstrap replicates of the mean estimates.}
\item{boot.sds}{Bootstrap replicates of the standard deviation estimates.}
}
\description{
Computes a parametric bootstrap standard error estimate for the method for unknown non-normal distributions approach.
}
\examples{
## Generate S2 summary data
set.seed(1)
n <- 250
x <- stats::rlnorm(n, 5, 0.25)
quants <- stats::quantile(x, probs = c(0, 0.5, 1))

## Estimate the mean and its standard error
res <- mln.mean.sd(min.val = quants[1], med.val = quants[2], max.val = quants[3],
                  n = n)
get_SE(res)$est.se
}
\references{
McGrath S., Katzenschlager S., Zimmer A.J., Seitel A., Steele R., Benedetti A. (In preparation). Standard error estimation in meta-analysis of studies reporting medians.

Cai S., Zhou J., and Pan J. (2021). Estimating the sample mean and standard deviation from order statistics and sample size in meta-analysis. \emph{Statistical Methods in Medical Research}. \strong{30}(12):2701-2719.
}
\seealso{
\code{\link{mln.mean.sd}}
}
