% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oev.R
\name{oev}
\alias{oev}
\title{Calculate the overall ecological vulnerability of a community after disturbance}
\usage{
oev(
  type,
  metric_tf,
  response,
  vd_i,
  td_i,
  d_data = NULL,
  vb_i = NULL,
  tb_i = NULL,
  b_data = NULL,
  comm_d = NULL,
  comm_b = NULL,
  comm_t = NULL,
  method = "bray",
  binary = "FALSE",
  na_rm = TRUE
)
}
\arguments{
\item{type}{a string defining the type of stability (\code{"functional"} or \code{"compositional"}) to be calculated.}

\item{metric_tf}{a numerical vector, specifying the beginning and end of the
time period over which the stability metric should be measured.}

\item{response}{a string stating whether the stability metric should be
calculated using the log-response ratio between the values in the disturbed
system and the baseline (\code{response = "lrr"}) or using the state
variable values in the disturbed system alone (\code{response == "v"}).}

\item{vd_i}{a numeric vector containing the state variable in the
disturbed system or a string specifying the name of the column
containing said variable in the dataframe provided in \code{d_data}.}

\item{td_i}{a numeric vector containing the time or a string specifying the
name of the column containing the time in the dataframe provided
in \code{d_data}.}

\item{d_data}{an optional data frame containing the time series of the
state variable values in a disturbed system.}

\item{vb_i}{an optional numeric vector containing the state variable in
the baseline, or a string for the name of the column in \code{b_data}
containing said variable in the dataframe with baseline values.}

\item{tb_i}{an optional numeric vector containing the time period over which
the baseline was measured, or a string for the name of the column in
\code{b_data} containing said the time variable in the dataframe
with baseline values.}

\item{b_data}{an optional data frame containing the time series of the
state variable values in the baseline.}

\item{comm_d}{a data frame containing long format community data
(species as columns over time as rows) to calculate compositional metrics.}

\item{comm_b}{a data frame containing long format community data (species
names as columns over time as rows) to calculate compositional metrics.}

\item{comm_t}{the name of the time variable in comm_b and comm_d.}

\item{method}{a string identifying the dissimilarity index to be used to
calculate dissimilarity. For more options, see \code{?vegdist}.
Defaults to "bray".}

\item{binary}{a boolean stating whether presence/absence standardization
should be performed before calculating the dissimilarity. For more options,
see \code{?vegdist}. Defaults to "bray".}

\item{na_rm}{a logical determining whether NAs should be taken out prior
to the estimation of the stability metric. Defaults to TRUE.}
}
\value{
A single numeric value, the overall ecological vulnerability.
\eqn{OEV \ge 0}
. The higher the value, the less stable the system.
}
\description{
\code{oev} returns the overall ecological vulnerability \eqn{OEV}
, calculated as the area under the curve ( \eqn{AUC} ) of the absolute
log-response-ratio (functional stability) or the dissimilarity
(compositional stability) between the disturbed and baseline communities
.
The area under the curve is calculated through trapezoidal integration.
}
\details{
The overall ecosystem variability (OEV) is defined as the area under the
curve (AUC) of the system's response through time.
For functional stability, the response is the log response ratio between
the state variable’s value in the disturbed ( \eqn{v_d} ) and in the baseline
systems ( \eqn{v_b} or \eqn{v_p} if the baseline is pre-disturbance values).
For compositional stability, the response is the dissimilarity between the
disturbed ( \eqn{C_d} ) and baseline ( \eqn{C_b} ) communities.
Therefore,

\eqn{
\mathrm{OEV} = \mathrm{AUC}\!\left(
  \left\lvert \log\!\left( \frac{v_d(t)}{v_b(t)} \right) \right\rvert,\, t
\right)
}

or

\eqn{
\mathrm{OEV} = \mathrm{AUC}\!\left(
  \left\lvert \log\!\left( \frac{v_d(t)}{v_p(t)} \right) \right\rvert,\, t
\right)
}

or

\eqn{
\mathrm{OEV} = \mathrm{AUC}\!\left(
  \mathrm{dissim}\!\left( \frac{C_d(t)}{C_b(t)} \right),\, t
\right)
}

where the area under the curve is defined as

\eqn{
\mathrm{AUC}(y, t)
  = \sum_{i = 1}^{n - 1}
    \frac{\left(t_{i+1} - t_i\right)\left(y_i + y_{i+1}\right)}{2}
}
(trapezoidal integration).
}
\examples{
oev(
  type = "functional", response = "lrr", metric_tf = c(0.14, 56), vd_i = "statvar_db",
  td_i = "time", d_data = aquacomm_resps, vb_i = "statvar_bl", tb_i = "time",
  b_data = aquacomm_resps
)
oev(
  type = "compositional", metric_tf = c(0.14, 56), comm_d = comm_dist,
  comm_b = comm_base, comm_t = "time"
)
}
\references{
Urrutia-Cordero, P., Langenheder, S., Striebel, M., Angeler, D. G., Bertilsson, S., Eklöv, P., Hansson, L.-A., Kelpsiene, E., Laudon, H., Lundgren, M., Parkefelt, L., Donohue, I., & Hillebrand, H. (2022). Integrating multiple dimensions of ecological stability into a vulnerability framework. Journal of Ecology, 110(2), 374–386. \doi{10.1111/1365-2745.13804}
}
