% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_chi_index.R
\name{rt.chi.index}
\alias{rt.chi.index}
\title{Chi index 2D - 3D}
\usage{
rt.chi.index(
  vol,
  vol.ref,
  abs = TRUE,
  vol.max = vol.ref$max.pixel,
  dose.th = 0.02,
  delta.r = 3,
  analysis.th = 0.05,
  local = FALSE,
  local.th = 0.3,
  project.to.isocenter = TRUE,
  alias = "",
  description = NULL
)
}
\arguments{
\item{vol}{"volume" class object, which represents the measured volume.}

\item{vol.ref}{"volume" class object, which represents the reference volume.}

\item{abs}{Boolean. If \code{TRUE} (default), the absolute value of Chi is computed.}

\item{vol.max}{Positive number, by default equal to the maximum value of the reference volume.
See Details.}

\item{dose.th}{Number between 0 and 1, used to determine the dose difference criterion. See Details.}

\item{delta.r}{Positive number, in mm. Distance difference criterion.}

\item{analysis.th}{Number between 0 and 1. Only the voxels whose value are
greater than or equal \code{analyse.th * vol.max} are processed.}

\item{local}{Boolean. If \code{local = FALSE} (default), a global Chi index
is computed, and a local Chi index otherwise.}

\item{local.th}{Number between 0 and 1. Local threshold, only used if
\code{local = TRUE}. See Details.}

\item{project.to.isocenter}{Boolean. If \code{TRUE}, and if \code{vol} and
\code{vol.ref} are of modality "rtimage", the size of the pixels is corrected
to correspond to that found if the sensor was at the isocenter.}

\item{alias}{Character string, \code{$object.alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to Chi index setup.
\loadmathjax}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions).  The \code{$vol3D.data} field represents the Chi index.
Two fields are added:
the \code{$setup} field recalls the calculation setup, and the \code{$chi.info} field
details the number of dose points, the number of evaluated dose points,the rate
of evaluated dose points, the rate of absolute values of the Chi index below 1,
above 1.2 and 1.5,the max and the mean Chi index.
}
\description{
The \code{rt.chi.index} function computes the local or global
Chi index from a measurement and a reference. These latter are "volume" class
objects containing one (2D) or several planes (3D).
}
\details{
The Chi index of a voxel \mjeqn{n}{ascii} was defined by \emph{Bakai and al} \strong{[1]}.
It is computed from the formulae:
\mjdeqn{\chi_n = \frac{D_i-Dref_n}{\sqrt{{\Delta D}^2 + {\Delta r}^2~\cdot~\Vert \nabla Dref_n \Vert^2}}}{ascii}
If \code{abs = TRUE}, the used formulae is :
\mjdeqn{\chi_n = \frac{\vert D_i-Dref_n\vert}{\sqrt{{\Delta D}^2 + {\Delta r}^2~\cdot~\Vert \nabla Dref_n \Vert^2}}}{ascii}
with \mjeqn{D_i}{ascii} the measured dose at voxel \mjeqn{i}{ascii},
\mjeqn{Dref_n}{ascii} the reference dose at voxel \mjeqn{n}{ascii},
\mjeqn{\nabla Dref_n}{ascii} the gradient of reference dose at voxel \mjeqn{n}{ascii},
\mjeqn{\Delta r}{ascii} the distance difference criterion equal to \code{delta.r}, and
\mjeqn{\Delta D}{ascii} the distance difference criterion at voxel \mjeqn{n}{ascii} defined as follows:
\itemize{
\item If \code{local = FALSE} a global Chi index is computed and
\mjeqn{\Delta D~=~dose.th~\cdot~vol.max}{ascii}.
\item If \code{local = TRUE}, then \mjeqn{\Delta D~=~dose.th~\cdot~Dref_n}{ascii} when
\mjeqn{Dref_n~\ge~local.th~\cdot~vol.max}{ascii}, and
\mjeqn{\Delta D~=~dose.th~\cdot~local.th~\cdot~vol.max}{ascii} otherwise.
}
}
\examples{
# Creation of a reference volume  and measured volume
# loading of toy-patient objects (decrease dxyz for  better result)
patient <- toy.load.patient (modality = c ("rtdose", "rtstruct"), 
                             roi.name = "ptv", dxyz = c (3, 3, 3))
D.ref <- patient$rtdose[[1]]  
# We will assume that the measured dose is equal to the reference dose shifted
# by 3 pixels on the x axis
D.meas <- vol.copy (D.ref, alias = "measured_dose")
D.meas$vol3D.data[1:(D.meas$n.ijk[1] - 3) ,,] <- D.ref$vol3D.data[4:D.ref$n.ijk[1],,] 
D.max <- as.numeric(quantile(as.numeric(D.ref$vol3D.data), 
                             probs = 99.99/100, na.rm = TRUE))
abs_chi <- rt.chi.index (D.meas, D.ref, vol.max = D.max, delta.r = 6)  
abs_chi$chi.info  

# Display chi index at isocenter
G.iso <- patient$rtstruct[[1]]$roi.info$Gz[
  patient$rtstruct[[1]]$roi.info$name == "ptv"]
display.plane(abs_chi, view.coord = G.iso, 
              bottom.col = c ("#00FF00", "#007F00", "#FF8000", "#FF0000", 
                              "#AF0000"),
              bottom.breaks = c (0, 0.8, 1, 1.2, 1.5, abs_chi$max.pixel),
              interpolate = FALSE, bg = "blue")
}
\references{
\strong{[1]} \insertRef{bakai2003}{espadon}
}
\seealso{
\link[espadon]{rt.gamma.index}
}
