% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_differentiate.R
\name{signal_differentiate}
\alias{signal_differentiate}
\title{Differentiate a signal vector}
\usage{
signal_differentiate(data)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}
}
\value{
Derivative of the input data set.
}
\description{
The function integrates a signal vector to, for example convert values from 
displacement to velocity.
}
\examples{

## load example data set
data(rockfall)

## detrend and demean data set
s <- signal_demean(signal_detrend(data = rockfall_eseis))

## differentiate
s_d = signal_differentiate(data = s)

## plot result
plot(s_d)

}
\author{
Michael Dietze
}
\keyword{eseis}
