% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_components.R
\name{plot_components}
\alias{plot_components}
\title{Plot three seismic components against each other}
\usage{
plot_components(data, type = "2D", order = "xyz", ...)
}
\arguments{
\item{data}{\code{List}, \code{data frame} or \code{matrix}, seismic
componenents to be processed. If \code{data} is a matrix, the components 
must be organised as columns. Also, \code{data} can be a list of 
\code{eseis} objects.}

\item{type}{\code{Character} value, plot type. One out of \code{"2D"} 
(panel of three 2-dimensional plots), \code{"3D"} (perspective 3D plot)
and \code{"scene"} (interactive 3D plot). Default is \code{"2D"}.}

\item{order}{\code{Caracter} value, order of the seismic components. 
Describtion must contain the letters \code{"x"},\code{"y"} and
\code{"z"} in the order according to the input data set. Default is 
\code{"xyz"} (NW-SE-vertical).}

\item{\dots}{Further arguments passed to the plot function.}
}
\value{
A plot
}
\description{
The function visualises the time evolution of three seismic components 
of the same signal against each other as line graphs. There are three 
different visualisation types available: \code{2D} (a panel of three 
2D plots), \code{3D} (a perspective threedimensional plot) and 
\code{scene} (an interactive threedimensional plot, mainly for 
exploratory purpose).
}
\details{
The plot type \code{type = "3D"} requires the package \code{plot3D} 
being installed. The plot type \code{type = "scene"} requires the  
package \code{rgl} being installed.
}
\examples{

## load example data set
data(earthquake)

## filter seismic signals
s <- eseis::signal_filter(data = s, 
                          dt = 1/200, 
                          f = c(0.05, 0.1))

## integrate signals to get displacement
s_d <- eseis::signal_integrate(data = s, dt = 1/200)

## plot components in 2D
plot_components(data = s_d, 
                type = "2D")

## plot components with time colour-coded
plot_components(data = s_d, 
                type = "2D",
                col = rainbow(n = length(s$BHE)))

## plot components with used defined coulour ramp
col_user <- colorRampPalette(colors = c("grey20", "darkblue", "blue", 
                                        "green", "red", "orange"))

plot_components(data = s_d, 
                type = "2D",
                col = col_user(n = length(s$BHE)))

## plot components as 3D plot
plot_components(data = s_d, 
                type = "3D",
                col = rainbow(n = length(s$BHE)))
                
}
\author{
Michael Dietze
}
\keyword{eseis}
