% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate-errors.R
\name{locate_errors}
\alias{locate_errors}
\alias{locate_errors,data.frame,validator-method}
\alias{locate_errors,data.frame,ErrorLocalizer-method}
\title{Locate errors in data}
\usage{
locate_errors(
  data,
  x,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)

\S4method{locate_errors}{data.frame,validator}(
  data,
  x,
  weight = NULL,
  ref = NULL,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)

\S4method{locate_errors}{data.frame,ErrorLocalizer}(
  data,
  x,
  weight = NULL,
  ref = NULL,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)
}
\arguments{
\item{data}{data to be checked}

\item{x}{validation rules or errorlocalizer object to be used for finding
possible errors.}

\item{...}{optional parameters that are passed to \code{\link[lpSolveAPI:lp.control]{lpSolveAPI::lp.control()}} (see details)}

\item{cl}{optional parallel / cluster.}

\item{Ncpus}{number of nodes to use. See details}

\item{timeout}{maximum number of seconds that the localizer should use per record.}

\item{weight}{\code{numeric} optional weight vector to be used in the error localization.}

\item{ref}{\code{data.frame} optional reference data to be used in the rules checking}
}
\value{
\code{\link[=errorlocation-class]{errorlocation-class()}} object describing the errors found.
}
\description{
Locate erroneuous fields in rows of data using validation rules or a specific
errorlocalizer object. This method returns found errors, according to the specified
method \code{x}.
Use method \code{\link[=replace_errors]{replace_errors()}}, to automatically remove these errors.
}
\details{
\code{locate_errors} uses lpSolveAPI to formulate and solve a mixed integer problem.
This solver has many options:  \link[lpSolveAPI:lp.control.options]{lpSolveAPI::lp.control.options}. Noteworthy
options to be used are:
\itemize{
\item \code{timeout}: restricts the time the solver spends on a record (seconds)
\item \code{break.at.value}: set this to minimum weight + 1 to improve speed.
}

\code{locate_errors} can be run on multiple cores using R package \code{parallel}.
\itemize{
\item The easiest way to use the parallel option is to set \code{Ncpus} to the number of
desired cores, @seealso \code{\link[parallel:detectCores]{parallel::detectCores()}}.
\item Alternatively one can create a cluster object (\code{\link[parallel:makeCluster]{parallel::makeCluster()}})
and use \code{cl} to pass the cluster object.
\item Or set \code{cl} to an integer which results in \code{\link[parallel:mclapply]{parallel::mclapply()}}, which only works
on non-windows.
}
}
\examples{
rules <- validator( profit + cost == turnover
                  , cost >= 0.6 * turnover # cost should be at least 60\% of turnover
                  , turnover >= 0 # can not be negative.
                  )
data <- data.frame(profit=755, cost=125, turnover=200)
le <- locate_errors(data, rules)

print(le)
summary(le)

v_categorical <- validator( A \%in\% c("a1", "a2")
                          , B \%in\% c("b1", "b2")
                          , if (A == "a1") B == "b1"
)

data <- data.frame(A = c("a1", "a2"), B = c("b2", "b2"))
locate_errors(data, v_categorical)$errors

v_logical <- validator( A \%in\% c(TRUE, FALSE)
                      , B \%in\% c(TRUE, FALSE)
                      ,  if (A == TRUE) B == TRUE
                      )

data <- data.frame(A = TRUE, B = FALSE)
locate_errors(data, v_logical, weight=c(2,1))$errors

# try a condinational rule
v <- validator( married \%in\% c(TRUE, FALSE), if (married==TRUE) age >= 17 )
data <- data.frame( married = TRUE, age = 16)
locate_errors(data, v, weight=c(married=1, age=2))$errors

}
\seealso{
Other error finding: 
\code{\link{errorlocation-class}},
\code{\link{errors_removed}()},
\code{\link{replace_errors}()}
}
\concept{error finding}
