% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{p_laplace}
\alias{p_beta}
\alias{p_gaussian}
\alias{p_laplace}
\alias{p_moge}
\alias{p_weibull}
\title{Probability Density Functions}
\usage{
p_laplace(x, mu = 0, sigma = 1)

p_gaussian(x, mu = 0, sigma_cuad = 1)

p_beta(x, alpha = 1, beta = 1)

p_weibull(x, k = 1, lambda = 1)

p_moge(x, lambda = 1, alpha = 1, theta = 1)
}
\arguments{
\item{x}{vector of points which values we want to compute.}

\item{mu}{location or mean parameter of the Laplace or Gaussian distribution,
respectively.}

\item{sigma}{scale parameter of the Laplace distribution.}

\item{sigma_cuad}{variance parameter of the Gaussian distribution.}

\item{alpha}{shape1 parameter of the Beta distribution or second parameter of the MOGE distribution.}

\item{beta}{shape2 parameter of the Beta distribution.}

\item{k}{shape parameter of the Weibull distribution.}

\item{lambda}{scale parameter of the Weibull distribution or first parameter of the MOGE distribution.}

\item{theta}{third parameter of the MOGE distribution.}
}
\value{
Returns a \code{numeric} object corresponding to the value
of the probability density function for the given x and distribution parameters.
}
\description{
\code{p_laplace} computes the probability density function
of a random variable that has a Laplace distribution with parameters \eqn{\mu} and
\eqn{\sigma}.

\code{p_gaussian} computes the probability density function
of a random variable that has a Gaussian distribution with parameters \eqn{\mu} and
\eqn{{\sigma}^2}{\sigma^2}.

\code{p_beta} computes the probability density function
of a random variable that has a Beta distribution with parameters \eqn{\alpha} and
\eqn{\beta}.

\code{p_weibull} computes the probability density function
of a random variable that has a Weibull distribution with parameters \eqn{\kappa}
and \eqn{\lambda}.

\code{p_moge} computes the probability density function
of a random variable that has a MOGE distribution with parameters \eqn{\lambda},\eqn{\alpha}
and \eqn{\theta}.
}
\examples{
p_laplace(0.3)
p_laplace(0.3,mu=0.35,sigma=0.2)


p_gaussian(0.3)
p_gaussian(0.3,mu=0.35,sigma_cuad=0.2)


p_beta(0.3)
p_beta(0.3,alpha=0.35,beta=0.2)


p_weibull(0.3)
p_weibull(0.3,k=0.35,lambda=0.2)


p_moge(0.3)
p_moge(0.3,lambda=0.2,alpha=0.3,theta=0.4)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}
\seealso{
\link{dlaplace}

\link{dnorm}

\link{dbeta}

\link{dweibull}
}

