% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.bipartite.degree.R
\name{b1mindegree-ergmTerm}
\alias{b1mindegree-ergmTerm}
\alias{InitErgmTerm.b1mindegree}
\title{Minimum degree for the first mode in a bipartite network}
\usage{
# binary: b1mindegree(d)
}
\arguments{
\item{d}{a vector of distinct integers.}
}
\description{
This term adds one network statistic to the model for
each element in \code{d} ; the \eqn{i} th such statistic equals the number of
nodes in the first mode of a bipartite network with at least degree \code{d[i]} .
The first mode of a bipartite network object is sometimes known as the "actor" mode.
}
\note{
This term can only be used with undirected bipartite networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b1mindegree", "subsection")}
}
\concept{bipartite}
\concept{undirected}
