% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/godfather.R
\name{ergm.godfather}
\alias{ergm.godfather}
\title{A function to apply a given series of changes to a network.}
\usage{
ergm.godfather(
  formula,
  changes = NULL,
  response = NULL,
  end.network = FALSE,
  stats.start = FALSE,
  changes.only = FALSE,
  verbose = FALSE,
  control = control.ergm.godfather()
)
}
\arguments{
\item{formula}{An \code{\link{ergm}}-style formula, with a
\code{\link{network}} on its LHS.}

\item{changes}{Either a matrix with three columns: tail, head, and
new value, describing the changes to be made; or a list of such
matrices to apply these changes in a sequence. For binary network
models, the third column may be omitted. In that case, the
changes are treated as toggles. Note that if a list is passed, it
must either be all of changes or all of toggles.}

\item{response}{Either a character string, a formula, or \code{NULL} (the default), to specify the response attributes and whether the ERGM is binary or valued. Interpreted as follows: \describe{

\item{\code{NULL}}{Model simple presence or absence, via a binary ERGM.}

\item{character string}{The name of the edge attribute whose value is to be modeled. Type of ERGM will be determined by whether the attribute is \code{\link{logical}} (\code{TRUE}/\code{FALSE}) for binary or \code{\link{numeric}} for valued.}

\item{a formula}{must be of the form \code{NAME~EXPR|TYPE} (with \code{|} being literal). \code{EXPR} is evaluated in the formula's environment with the network's edge attributes accessible as variables. The optional \code{NAME} specifies the name of the edge attribute into which the results should be stored, with the default being a concise version of \code{EXPR}. Normally, the type of ERGM is determined by whether the result of evaluating \code{EXPR} is logical or numeric, but the optional \code{TYPE} can be used to override by specifying a scalar of the type involved (e.g., \code{TRUE} for binary and \code{1} for valued).}

}}

\item{end.network}{Whether to return a network that
results. Defaults to \code{FALSE}.}

\item{stats.start}{Whether to return the network statistics at
\code{start} (before any changes are applied) as the first row of
the statistics matrix.  Defaults to \code{FALSE}, to produce
output similar to that of \code{\link[=simulate.ergm]{simulate}}
for ERGMs when \code{output="stats"}, where initial network's
statistics are not returned.}

\item{changes.only}{Whether to return network statistics or only
their changes relative to the initial network.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{control}{A list of control parameters for algorithm tuning,
typically constructed with \code{\link[=control.ergm.godfather]{control.ergm.godfather()}}. Its documentation
gives the the list of recognized control parameters and their
meaning. The more generic utility \code{\link[=snctrl]{snctrl()}} (StatNet ConTRoL)
also provides argument completion for the available control
functions and limited argument name checking.}
}
\value{
If \code{end.network==FALSE} (the default), an
\code{\link{mcmc}} object with the requested network statistics
associed with the network series produced by applying the
specified changes. Its \code{\link{mcmc}} attributes encode the
timing information: so \code{\link{start}(out)} gives the time
point associated with the first row returned, and
\code{\link{end}(out)} out the last. The "thinning interval" is
always 1.

If \code{end.network==TRUE}, return a \code{\link{network}} object,
representing the final network, with a matrix of statistics
described in the previous paragraph attached to it as an
\code{attr}-style attribute \code{"stats"}.
}
\description{
Gives the network a series of proposals it can't refuse. Returns the
statistics of the network, and, optionally, the final network.
}
\examples{
data(florentine)
ergm.godfather(flomarriage~edges+absdiff("wealth")+triangles,
               changes=list(cbind(1:2,2:3),
                            cbind(3,5),
                            cbind(3,5),
                            cbind(1:2,2:3)),
               stats.start=TRUE)
}
\seealso{
\code{\link[tergm:tergm.godfather]{tergm::tergm.godfather()}}, \code{\link[=simulate.ergm]{simulate.ergm()}},
\code{\link[=simulate.formula]{simulate.formula()}}
}
