% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.Cprepare.R, R/rlebdm.R,
%   R/to_ergm_Cdouble.R
\name{to_ergm_Cdouble.network}
\alias{to_ergm_Cdouble.network}
\alias{to_ergm_Cdouble.matrix}
\alias{to_ergm_Cdouble.rlebdm}
\alias{to_ergm_Cdouble}
\title{Methods to serialize objects into numeric vectors for passing to the C side.}
\usage{
\method{to_ergm_Cdouble}{network}(x, attrname = NULL, ...)

\method{to_ergm_Cdouble}{matrix}(x, prototype = NULL, ...)

\method{to_ergm_Cdouble}{rlebdm}(x, ...)

to_ergm_Cdouble(x, ...)
}
\arguments{
\item{x}{object to be serialized.}

\item{attrname}{name of an edge attribute.}

\item{...}{arguments for methods.}

\item{prototype}{A network whose relevant attributes (size,
directedness, bipartitedness, and presence of loops) are imposed
on the output edgelist if \code{x} is already an edgelist. (For
example, if the prototype is undirected, \code{to_ergm_Cdouble}
will ensure that \eqn{t < h}.)}
}
\value{
The \code{\link{rlebdm}} method returns a vector with the following:
\itemize{
\item number of nonzero dyads,
\item number of runs of nonzeros,
\item starting positions of the runs, and
\item cumulative lengths of the runs, prepended with 0.
}
}
\description{
These methods return a vector of \code{\link{double}}s. For edge lists, this
usually takes the form of a \eqn{2 e + 1}- or \eqn{3 e + 1}-vector,
containing the number of edges followed a column-major
serialization of the edgelist matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{network}: Method for \code{\link{network}} objects.

\item \code{matrix}: Method for \code{\link{matrix}} objects, assumed to be edgelists.

\item \code{rlebdm}: Method for \code{\link{rlebdm}} objects.
}}

\keyword{internal}
