% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.multi-package.R
\docType{package}
\name{ergm.multi-package}
\alias{ergm.multi}
\alias{ergm.multi-package}
\title{ergm.multi: Fit, Simulate and Diagnose Exponential-Family Models for Multiple or Multilayer Networks}
\description{
A set of extensions for the 'ergm' package to fit multilayer/multiplex/multirelational networks and samples of multiple networks. 'ergm.multi' is a part of the Statnet suite of packages for network analysis. See Krivitsky, Koehly, and Marcum (2020) \doi{10.1007/s11336-020-09720-7} and Krivitsky, Coletti, and Hens (2023) \doi{10.1080/01621459.2023.2242627}.
}
\section{Multilayer network models}{
 Also known as multiplex,
multirelational, or multivariate networks, in a multilayer network a pair
of actors can have multiple simultaneous relations of different
types. For example, in the \link{Lazega} lawyer data set included with
this package, each pair of lawyers in the firm can have an advice
relationship, a coworking relationship, a friendship
relationship, or any combination thereof. Application of ERGMs to
multilayer networks has a long history
\insertCite{PaWa99l,LaPa99m}{ergm.multi}, and a number of \R
packages exist for analysing and estimating them.

\pkg{ergm.multi} implements the general approach of
\insertCite{KrKo20e;textual}{ergm.multi} for specifying
multilayer ERGMs, including Layer Logic and the various
cross-layer specifications. Its features include:

\describe{

\item{seamless integration with \code{\link[=ergm]{ergm()}}:}{Multilayer
specification is contained entirely in an \code{\link[=ergm]{ergm()}}-style formula and can be
nested with any other \code{\link[=ergm]{ergm()}} terms, including dynamic and multi-network.}

\item{unlimited layers:}{The number of layers in the modeled
network is limited only by computing power.}

\item{flexibility and simplicity:}{\emph{Any} valid binary ERGM can be
specified for any layer or a logical combination of layers
using simple term operators.}

\item{heterogeneous layers:}{A network can have directed and
undirected layers, which can be modeled jointly.}

\item{multimode/multilevel support (experimental):}{With some
care, it is possible to specify models for unipartite and
bipartie layers over different subsets of actors, which can be
used to specify multimode models.}

}

See \code{\link[=Layer]{Layer()}} and \code{\link[=L-ergmTerm]{ergmTerm?L}} for examples.
}

\section{Multi-network models}{
 Joint modeling of independent
samples of networks on disjoint sets of actors have a long
history as well \insertCite{@@ZiVa06m, @SlKo16m, @StSc19m, and @VeSl21e, for example}{ergm.multi}.
\pkg{ergm.multi} facilitates
fixed-effect models for samples of networks (possibly
heterogeneous in size and composition), using a multivariate
linear model for each network's ERGM parameters, with
network-level attributes serving as predictors, as formulated by
\insertCite{SlKo16m;textual}{ergm.multi} and
\insertCite{KrCo22t;textual}{ergm.multi}.

Its features include:

\describe{

\item{seamless integration with \code{\link[=ergm]{ergm()}}:}{Multi-network model
specification is contained entirely in an \code{\link[=ergm]{ergm()}}-style formula and can be
nested with any other \code{\link[=ergm]{ergm()}} terms, including dynamic and multilayer.}

\item{flexibility and simplicity:}{\emph{Any} valid binary or valued
ERGM can be specified for the networks, using simple term
operators and the network-level specification with an
\code{\link[=lm]{lm()}}-style formula.}

}

See \code{\link[=Networks]{Networks()}}, \code{\link[=N-ergmTerm]{ergmTerm?N}} for specification,
\code{\link[=gofN]{gofN()}} for diagnostic facilities, and
\code{vignette("Goeyvaerts_reproduction")} for a demonstration.
}

\references{
\insertAllCited{}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://statnet.org}
  \item Report bugs at \url{https://github.com/statnet/ergm.multi/issues}
}

}
\author{
\strong{Maintainer}: Pavel N. Krivitsky \email{pavel@statnet.org} (\href{https://orcid.org/0000-0002-9101-3362}{ORCID})

Other contributors:
\itemize{
  \item Mark S. Handcock \email{handcock@stat.ucla.edu} [contributor]
  \item David R. Hunter \email{dhunter@stat.psu.edu} [contributor]
  \item Chad Klumb \email{cklumb@gmail.com} [contributor]
  \item Pietro Coletti \email{pietro.coletti@uhasselt.be} [contributor]
  \item Joyce Cheng \email{joyce.cheng@student.unsw.edu.au} [contributor]
}

}
\keyword{models}
\keyword{package}
