% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egor.R
\name{sample}
\alias{sample}
\alias{sample.default}
\alias{sample.egor}
\title{Draw random egocentric subsamples}
\usage{
sample(x, size, replace = FALSE, prob = NULL, ...)

\method{sample}{default}(x, ...)

\method{sample}{egor}(x, size, replace = FALSE, prob = NULL, ...)
}
\arguments{
\item{x, size, replace, prob}{see \code{\link[base:sample]{base::sample()}}.}

\item{...}{extra arguments, currently unused.}
}
\value{
An \code{\link[egor:egor]{egor::egor()}} object whose egos have been resampled in
accordance with the arguments. Note that its \code{\link[egor:ego_design]{egor::ego_design()}}
information is overwritten in favor of the selection
probabilities used in the sampling.
}
\description{
Implementations of the \code{\link[base:sample]{base::sample()}} function for \code{\link[egor:egor]{egor::egor()}} data.
}
\note{
A reimplementation of sample as a generic was necessary
because \code{\link[base:sample]{base::sample()}} is not a generic and cannot take
data-frame-alikes as arguments.
}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)

# Create a tiny weighted sample:
(s3 <- sample(fmh.ego, 3, replace=TRUE, prob=1:nrow(fmh.ego$ego)))
# Resampling with prob=weights(egor) creates a self-weighted
# sample:
(sample(s3, 3, replace=TRUE, prob=weights(s3)))

# Create a large weighted sample, oversampling 12th-graders:
p <- ifelse(as_tibble(fmh.ego$ego)$Grade==12, 2, 1)
s2000 <- sample(fmh.ego, 2000, replace=TRUE, prob=p)

# Summary function adjusts for weights:
(summ.net <- summary(faux.mesa.high ~ edges + nodematch("Grade") +
                     nodefactor("Race") + gwesp(0,fix=TRUE)))
(summ.ego <- summary(s2000 ~ edges + nodematch("Grade") + 
                     nodefactor("Race") + gwesp(0,fix=TRUE),
                     scaleto=network.size(faux.mesa.high)))

\dontshow{
stopifnot(isTRUE(all.equal(
  as.vector(summ.net),
  as.vector(summ.ego),
  tolerance=.05,
  check.attributes=FALSE
)))
}

}
