% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.egor.R
\name{*.svystat}
\alias{*.svystat}
\title{A scalar multiplication method for \code{svystat}}
\usage{
\method{*}{svystat}(x, y)
}
\arguments{
\item{x}{an object of class \verb{[svystat][survey::svymean]}.}

\item{y}{a numeric vector equal in length to \code{x}; shorter vectors will be recycled.}
}
\value{
a \verb{[svystat][survey::svymean]} object with the updated statistics and variance-covariance matrix.
}
\description{
Multiply the values of survey statistics by a specified vector elementwise, adjusting the variance.
}
\examples{
library(survey)
data(api)
# From example(svymean):
dclus1<-svydesign(id=~dnum, weights=~pw, data=apiclus1, fpc=~fpc)

(m1 <- svymean(~api99, dclus1))
(v1 <- vcov(m1))

# Scale the suvery stat object by a factor of two:
(m2 <- m1 * 2)
(v2 <- vcov(m2))

\dontshow{
stopifnot(isTRUE(all.equal(as.vector(m2), as.vector(m1)*2, check.attributes=FALSE)))
stopifnot(isTRUE(all.equal(v2, v1*4)))
}
}
