% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.statistics.egor.R
\name{summary_formula.egor}
\alias{summary_formula.egor}
\alias{summary_formula.egodata}
\alias{summary}
\alias{summary_formula}
\alias{*.ergm.ego_svystat}
\title{Calculation of ERGM-style summary statistics for \code{\link{egor}}
objects.}
\usage{
\method{summary_formula}{egor}(object, ..., basis = NULL, individual = FALSE, scaleto = NULL)

\method{*}{ergm.ego_svystat}(x, y)
}
\arguments{
\item{object}{An \code{\link[ergm]{ergm}}-style formula with a
\code{\link{egor}} object as the LHS.

For a list of currently implemented egocentric terms for the RHS, see
\code{\link{ergm.ego-terms}}.}

\item{\dots}{Not used at this time.}

\item{basis}{An optional \code{\link{egor}} object relative to which the
statistics should be calculated.}

\item{individual}{If \code{FALSE} (the default), calculate the estimated
per-capita statistics, weighted according to the ego weights, then scale
them up to a network of size \code{scaleto}.

If \code{TRUE}, calculate each ego's individual contribution to the
specified network statistics.}

\item{scaleto}{Size of a hypothetical network to which to scale the
statistics. Defaults to the number of egos in the dataset.}

\item{x, y}{see \code{\link{*.svystat}}.}
}
\value{
If \code{individual==FALSE}, an \code{ergm.ego_svystat} object, which is a subclass of \link[survey:surveysummary]{svystat}---effectively a named vector of statistics. If
\code{individual==TRUE}, a matrix with a row for each ego, giving that ego's
contribution to the network statistic.
}
\description{
Used to calculate the specified network statistics inferred from a
\code{\link{egor}} object.
}
\section{Functions}{
\itemize{
\item \code{ * }: A multiplication method that takes into account which statistics are scalable.

}}
\examples{

data(faux.mesa.high)
fmh.ego <- as.egor(faux.mesa.high)
(nw.summ <- summary(faux.mesa.high~edges+degree(0:3)+nodematch("Race")+
                    nodematch("Sex")+absdiff("Grade")+nodemix("Grade")))

(ego.summ <- summary(fmh.ego~edges+degree(0:3)+nodematch("Race")+nodematch("Sex")+
                     absdiff("Grade")+nodemix("Grade"),
                     scaleto=network.size(faux.mesa.high)))

stopifnot(isTRUE(all.equal(as.vector(nw.summ),as.vector(ego.summ))))


(ego.summ2 <- summary(fmh.ego ~ edges + meandeg + degree(0:2)))
vcov(ego.summ2)

ego.summ2 * 2 # edges and degrees scales, meandeg doesn't
vcov(ego.summ2 * 2)

}
\references{
\itemize{
\item Pavel N. Krivitsky and Martina Morris (2017). "Inference for social network models from egocentrically sampled data, with application to understanding persistent racial disparities in HIV prevalence in the US." \emph{Annals of Applied Statistics}, 11(1): 427–455. \doi{10.1214/16-AOAS1010}
\item Pavel N. Krivitsky, Mark S. Handcock, and Martina Morris (2011). "Adjusting for
Network Size and Composition Effects in Exponential-Family Random Graph
Models." \emph{Statistical Methodology}, 8(4): 319–339. \doi{10.1016/j.stamet.2011.01.005}
}
}
\seealso{
\code{\link[ergm]{summary_formula}},
\code{\link[ergm]{summary_formula.ergm}}
}
\author{
Pavel N. Krivitsky
}
