% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egodata.R
\name{[.egodata}
\alias{[.egodata}
\alias{subset.egodata}
\title{Subsetting \code{\link{egodata}} Objects}
\usage{
\method{[}{egodata}(x, i, j, ..., dup.action = c("make.unique", "fail", "number"))

\method{subset}{egodata}(x, subset, select, ..., dup.action = c("make.unique", "fail", "number"))
}
\arguments{
\item{x}{An \code{\link{egodata}} object.}

\item{\dots}{Additional arguments, currently unused.}

\item{dup.action}{What to do when an ego is referenced multiple times:
\describe{ \item{"make.unique"}{Construct new unique ego IDs using
the \code{\link[base]{make.unique}} function } \item{"fail"}{Exit
with an error.} \item{"number"}{Number the egos consecutively in
the order they were selected } }}

\item{subset, i}{An expression (evaluated in the context of the \code{egos}
table of \code{x} producing a logical, integer, or character vector
indicating which egos to select (and, for the latter two, how many times).}

\item{select, j}{A numeric or character vector specifying the columns of
\code{egos} and \code{alters} to select.}
}
\value{
An \code{\link{egodata}} object.
}
\description{
Returns subsets of \code{\link{egodata}} objects that meet conditions.
}
\seealso{
\code{\link{sample.egodata}}
}
\author{
Pavel N. Krivitsky
}
\keyword{manip}
