\name{drop.peakfeat}
\alias{drop.peakfeat}
\title{Erase peak features in peak object}
\description{
Erase chosen peak features informations from a \command{peak} object.
}
\usage{
drop.peakfeat(peak, feat)
}
\arguments{
	\item{peak}{ An object of class \command{peak}. See \command{define.peak} function for details. }
	\item{feat}{ A character string vector containing the names of the features to delete. Features could be: \command{"additive.effect"},\command{"peak.bp"},\command{"inf.bp"},\command{"sup.bp"} or \command{"type"}. See \command{calc.adef}, \command{localize.qtl},\command{classify.qtl} functions for details.}
}
\details{ In \command{peak} object, QTL is defined by peak features. This function is useful to erase some peak features by avoiding to redo all the analyses (mainly the \command{define.peak} function). Only the peak features generated by the functions \command{calc.adef}, \command{localize.qtl} and \command{classify.qtl} should be removed. This function is used by the functions 'calc.adef', 'localize.qtl' and 'classify.qtl'.
}
\value{ An object of class \command{peak} }
\author{ Hamid A. Khalili }
\seealso{\code{define.peak},\code{localize.qtl},\code{calc.adef},\code{classify.qtl}}
\examples{

data(seed10);

out.em <- scanone( seed10, pheno.col=1:50, model='normal', method='em')
out.peak <- define.peak(out.em,lodcolumn='CATrck');
out.peak <- calc.adef(seed10,out.em,out.peak)

out.peak;

data(BSpgmap);
out.peak <- localize.qtl(seed10,out.peak,BSpgmap);

out.peak;

out.peak <- drop.peakfeat(out.peak,'additive.effect');
out.peak <- drop.peakfeat(out.peak,c('inf.bp','sup.bp'));

out.peak;
}
\keyword{utilities}

