% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMultiMapRamp.R
\name{getMultiMapRamp}
\alias{getMultiMapRamp}
\title{Extract min and max for multiple epmGrids}
\usage{
getMultiMapRamp(...)
}
\arguments{
\item{...}{objects of class \code{epmGrid}, \code{RasterLayer}
\code{SpatRaster} or \code{sf} objects.}
}
\value{
a numeric vector of length 2: overall min and max value.
}
\description{
Extracts the range of values across a list of input
	objects for use in plotting
}
\details{
If the user would like to plot multiple epmGrid objects
with a standardized color ramp, then the returned values from this function
can be supplied to \code{\link{plot.epmGrid}}. Also works with RasterLayer
and sf objects. For sf object, only one attribute can be specified.
}
\examples{
library(terra)
tamiasEPM

# create a dummy raster for demonstration purposes.
ras <- rast()
values(ras) <- runif(ncell(ras), min = 0, max = 40)

getMultiMapRamp(tamiasEPM, ras)
 
}
\author{
Pascal Title
}
