% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition.R
\name{version_updater}
\alias{version_updater}
\title{Run IDFVersionUpdater to Update Model Versions}
\usage{
version_updater(idf, ver, dir = NULL, keep_all = FALSE)
}
\arguments{
\item{idf}{An \link{Idf} object or a path of IDF file.}

\item{ver}{A valid EnergyPlus version, e.g. \code{9}, \code{8.8}, or \code{"8.8.0"}.}

\item{dir}{The directory to save the new IDF files. If the directory does not
exist, it will be created before save. If \code{NULL}, the directory of input
\link{Idf} object or IDF file will be used. Default: \code{NULL}.}

\item{keep_all}{If \code{TRUE}, a list will be return which contains all
\link{Idf} objects of intermediate versions. The list will be named using first
two number of that version, e.g. \code{8.1}, \code{8.2}. If \code{FALSE}, only the \link{Idf}
object of the version specified by \code{ver} will be returned. Default: \code{FALSE}.}
}
\value{
An \link{Idf} object if \code{keep_all} is \code{FALSE} or a list of \link{Idf} objects
if \code{keep_all} is \code{TRUE}. An attribute named \code{errors} is attached which
contains all error messages from transition error (.VCpErr) files.
}
\description{
\code{version_updater()} is a wrapper of IDFVersionUpdater preprocessor
distributed with EnergyPlus. It takes a path of IDF file or an \link{Idf} object,
a target version to update to and a directory to save the new models.
}
\details{
An attribute named \code{errors} is attached which is a list of
\link[=read_err]{ErrFiles} that contain all error messages from transition error
(.VCpErr) files.
}
\examples{
\dontrun{
if (any(avail_eplus()) > 7.2) {
    # create an empty IDF
    idf <- empty_idf(7.2)
    idf$save(tempfile(fileext = ".idf"))

    # convert it from v7.2 to the latest EnergyPlus installed
    updated <- version_updater(idf, max(avail_eplus()))

    # convert it from v7.2 to the latest EnergyPlus installed and keep all
    intermediate versions
    updated <- version_updater(idf, max(avail_eplus()), keep_all = TRUE)

    # see transition error messages
    attr(updated, "errors")
}
}
}
\author{
Hongyuan Jia
}
