% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{group_job}
\alias{group_job}
\title{Create An EnergyPlus Parametric Simulation Job}
\usage{
group_job(idfs, epws)
}
\arguments{
\item{idfs}{Paths to EnergyPlus IDF files or a list of IDF files and \link{Idf}
objects.}

\item{epws}{Paths to EnergyPlus EPW files or a list of EPW files and \link{Epw}
objects. Each element in the list can be \code{NULL}, which will force
design-day-only simulation when \code{\link[=EplusGroupJob]{$run()}} method is called.
Note this needs at least one \code{Sizing:DesignDay} object exists in that \link{Idf}.
If \code{epws} is \code{NULL}, design-day-only simulation will be conducted for all
input models.}
}
\value{
A \code{EplusGroupJob} object.
}
\description{
\code{group_job()} takes IDFs and EPWs as input and returns a \code{EplusGroupJob}.
For details on \code{EplusGroupJob}, please see \link{EplusGroupJob} class.
}
\examples{
\dontrun{
if (is_avail_eplus(8.8)) {
    dir <- eplus_config(8.8)$dir
    path_idfs <- list.files(file.path(dir, "ExampleFiles"), "\\\\.idf",
        full.names = TRUE)[1:5]
    path_epws <- list.files(file.path(dir, "WeatherData"), "\\\\.epw",
        full.names = TRUE)[1:5]

    # create from local files
    group <- group_job(path_idfs, path_epws)

    # create from Idfs and Epws object
    group_job(lapply(path_idfs, read_idf), lapply(path_epws, read_epw))
}
}

}
\seealso{
\code{\link[=eplus_job]{eplus_job()}} for creating an EnergyPlus single simulation job.
}
\author{
Hongyuan Jia
}
