% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agents.R
\name{agents_smallworld}
\alias{agents_smallworld}
\alias{agents}
\alias{agents_from_edgelist}
\alias{get_network}
\alias{network}
\title{Load agents to a model}
\usage{
agents_smallworld(model, n, k, d, p)

agents_from_edgelist(model, source, target, size, directed)

get_network(model)
}
\arguments{
\item{model}{Model object of class \link{epiworld_model}.}

\item{n, size}{Number of individuals in the population.}

\item{k}{Number of ties in the small world network.}

\item{d, directed}{Logical scalar. Whether the graph is directed or not.}

\item{p}{Probability of rewiring.}

\item{source, target}{Integer vectors describing the source and target of
in the edgelist.}
}
\value{
The 'agents_smallworld' function returns a model with the agents
loaded.

The \code{agents_from_edgelist} function returns an empty model of class
\code{epiworld_model}.

The \code{get_network} function returns a data frame with two columns
(\code{source} and \code{target}) describing the edgelist of the network.
}
\description{
These functions provide access to the network of the model. The network is
represented by an edgelist. The \code{agents_smallworld} function generates a
small world network with the Watts-Strogatz algorithm. The
\code{agents_from_edgelist} function loads a network from an edgelist.
The \code{get_network} function returns the edgelist of the network.
}
\examples{

# Initializing SIR model with agents_smallworld
sir <- ModelSIR(name = "COVID-19", prevalence = 0.01, infectiousness = 0.9, 
                recovery = 0.1)
agents_smallworld(
   sir,
   n = 1000, 
   k = 5,
   d = FALSE,
   p = .01
 )
run(sir, ndays = 100, seed = 1912)
sir

# We can also retrieve the network
net <- get_network(sir)
head(net)

# Simulating a bernoulli graph
set.seed(333)
n <- 1000
g <- matrix(runif(n ^ 2) < .01, nrow = n)
diag(g) <- FALSE
el <- which(g, arr.ind = TRUE) - 1L


# Generating an empty model
sir <- ModelSIR("COVID-19", .01, .8, .3)
agents_from_edgelist(
  sir,
  source = el[,1],
  target = el[,2],
  size   = n,
  directed = TRUE
)

# Running the simulation
run(sir, 50)

plot(sir)
}
