% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhcI.R
\name{mhcI}
\alias{mhcI}
\title{Prediction of Nonself Peptide Presentation on Human MHC Class I}
\usage{
mhcI(
  ag_present,
  ag_stim,
  ag_self = "",
  seq_len = "9",
  fd_out = as.character(paste0(tempdir(), "/", "outputs", "/")),
  method = "consensus",
  thold_ic50 = c(50, 500),
  thold_pect_rank = c(2, 10),
  url_iedb = "http://tools-cluster-interface.iedb.org/tools_api/mhci/",
  noneself = TRUE
)
}
\arguments{
\item{ag_present}{character vector, presenting allele, formatting examples - A*01:01 or HLA-A*01:01}

\item{ag_stim}{character vector, stimulating antigen, can either be an HLA class I allele entered in the same format as ag_present, or a character vector of the amino acid sequence of the protein}

\item{ag_self}{character, self antigen, can either be an HLA class I allele entered in the same format as ag_present, or a character vector of the amino acid sequence of the protein}

\item{seq_len}{string, length of peptides to consider}

\item{fd_out}{string, output folder name, set to tempdir()}

\item{method}{string, IEDB prediction method to be used. Options are ann, comblib_sidney2008, consensus, netmhccons, netmhcpan, netmhcpan_ba
netmhcpan_el, netmhcstabpan, pickpocket, recommended, smm, smmpmbec. Default is netmhcstabpan}

\item{thold_ic50}{vector. Defines the thresholds required to be included in results, and to be labeled, "strong" or "weak" binder. Multiple prediction methods are used, each of which provide different raw outputs (i.e. IC50, "strength", "score"). Our justification for the default thresholds is listed in the mhcI_hu vignette, however the user may choose to specify alternate cutoffs if desired.}

\item{thold_pect_rank}{vector, IEDB adjusts all outputs in comparison to a set of random natural peptides in order to determine an normalized adjusted percentile rank. With normalized ranks, the same thresholds can be used across different methods. Default thresholds are <2\% for strong binders and <10\% for weak binders.}

\item{url_iedb}{string, iedb api url}

\item{noneself}{logic, whether to subtract self peptide from stim. If TRUE|T, self peptides will be subtracted from stim. If FALSE|F no self subtraction.}
}
\value{
data frame, MHC I binding prediction result table
}
\description{
It determines which non-self peptides can be presented by a given HLA class I allele. This function takes a sequence for a stimulating antigen and the corresponding self antigen, and given a defined sequence length, queries the IEDB API with the user's choice of peptide binding prediction method. The set of peptides present in the results for the stimulating antigen but not the self antigen are then carried forward as non-self peptides. If desired, the user can adjust the default thresholds (by IC50 binding affinity or percentile rank) used to define "strong" and "weak" binders. The output is a dataframe of non-self peptides that are predicted to bind to the presenting allele.
}
\examples{
\donttest{
mhcI(ag_present=c("HLA-A*03:01"),
ag_stim=c("A_01_01","A_02_06"),
ag_self=c("B_07_03"),
method = "rec")
}
}
