% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utils}
\alias{utils}
\alias{preproc_huII}
\alias{pull_seq_huII}
\alias{prep_lbl_huII}
\alias{comb_pred_tbl}
\alias{find_nonself_huII}
\alias{pull_ag_self}
\alias{find_core_mut}
\alias{align_seq}
\title{Basic functions of the package}
\usage{
preproc_huII(allele_in)

pull_seq_huII(alleles_in, tbl_ref_in)

prep_lbl_huII(alleles_in)

comb_pred_tbl(nm_method, nm_sht, nm_fd, thold_score, thold_rank)

find_nonself_huII(dat_in)

pull_ag_self(dat_in)

find_core_mut(dat_in)

align_seq(seq1, seq2)
}
\arguments{
\item{allele_in}{a vector contains allele name(s)

pull_seq_huII() pull out sequence of each allele based on ref table}

\item{alleles_in}{vector, allele names

comb_pred_tbl() combine individual prediction tables by method, exclude none-binders and keep strong and weak binders only}

\item{tbl_ref_in}{dataframe, reference table, default is human_all.csv from github

prep_lbl_huII() concatenate allele strings for prediction table names}

\item{nm_method}{string, prediction method used for IEDB prediction}

\item{nm_sht}{string, short name of alleles}

\item{nm_fd}{string, folder name which contains predict tables from IEDB}

\item{thold_score}{list of vectors, binder thresholds by score}

\item{thold_rank}{vector, binder thresholds by rank

find_nonself_huII() find nonself binding peptides}

\item{dat_in}{dataframe with pep_stim, core, pep_self selected from pull_ag_self

align_seq() align protein sequences}

\item{seq1}{path to the fasta or fastq file to read}

\item{seq2}{path to the fasta or fastq file to read}
}
\description{
preproc_huII() format and validate allele names
}
