% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_functions.R
\name{odds_ratio}
\alias{odds_ratio}
\title{Builds a function used to calculate odds ratios.}
\usage{
odds_ratio(outcome, adjusted = FALSE, relevel_baseline = FALSE,
  digits = 2, ci = TRUE)
}
\arguments{
\item{outcome}{The dependent variable as a string.}

\item{adjusted}{Whether to adjust for the other covariates, specified by
\code{independents} argument to \code{contingency_table}.}

\item{relevel_baseline}{Whether to use the largest level as the baseline.}

\item{digits}{The number of digits to display.}

\item{ci}{Whether to include a confidence interval in parentheses after the estimate.}
}
\value{
A function that is used to calculate odds ratios.
}
\description{
Builds a function to run logistic regression on the
outcome variable of interest and return the odds ratios
for each covariate level.
}
\details{
See documentation for \code{contingency_table} and vignette
for usage.
}
