\name{probsens}
\alias{probsens}
\alias{probsens.conf, probsens.sel}
\title{Probabilistic sensitivity analysis.}
\description{Probabilistic sensitivity analysis to correct for exposure
  misclassification or outcome misclassification and random error.}
\usage{
probsens(exposed, case, type = c("exposure", "outcome"), reps = 1000,
seca.parms = list(dist = c("uniform", "triangular", "trapezoidal"),
parms = NULL), seexp.parms = NULL, spca.parms = list(dist = c("uniform",
"triangular", "trapezoidal"), parms = NULL), spexp.parms = NULL, corr.se
= NULL, corr.sp = NULL, alpha = 0.05, dec = 4, print = TRUE)
}
\arguments{
  \item{exposed}{Exposure variable. If a variable, this variable is tabulated against.}
  \item{case}{Outcome variable.}
  \item{type}{Choice of correction for exposure or outcome
    misclassification.}
  \item{reps}{Number of replications to run.}
  \item{seca.parms}{List defining the sensitivity of exposure
    classification among those with the outcome. The first argument
    provides the probability distribution function (uniform, triangular,
    or trapezoidal) and the second its parameters as a vector:
    \enumerate{
    \item Uniform: min, max,
    \item Triangular: lower limit, upper limit, mode,
    \item Trapezoidal: min, lower mode, upper mode, max.
    }
  }
  \item{seexp.parms}{List defining the sensitivity of exposure
    classification among those without the outcome.}
  \item{spca.parms}{List defining the specificity of exposure
    classification among those with the outcome.}
  \item{spexp.parms}{List defining the specifity of exposure
    classification among those without the outcome.}
  \item{corr.se}{Correlation between case and non-case sensitivities.}
  \item{corr.sp}{Correlation between case and non-case specificities.}
  \item{alpha}{Significance level.}
  \item{dec}{Number of decimals in the printout.}
  \item{print}{Should the results be printed?}
}
\value{A list with elements:
  \item{obs.data}{The analysed 2 x 2 table from the observed data.}
  \item{obs.measures}{A table of observed relative risk and odds ratio
    with confidence intervals.}
  \item{adj.measures}{A table of corrected relative risks and odds ratios.}
  \item{sim.df}{Data frame of random parameters and computed values.}
}
\references{Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying
    Quantitative Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.}
\author{Denis Haine \email{denis.haine@gmail.com}}
\examples{
# The data for this example come from:
# Greenland S., Salvan A., Wegman D.H., Hallock M.F., Smith T.J.
# A case-control study of cancer mortality at a transformer-assembly facility.
# Int Arch Occup Environ Health 1994; 66(1):49-54.
set.seed(123)
# Exposure misclassification, non-differential
probsens(matrix(c(45, 94, 257, 945),
                   dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")),
                   nrow = 2, byrow = TRUE),
         type = "exposure",
         reps = 20000,
         seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
         spca.parms = list("trapezoidal", c(.75, .85, .95, 1)))
# Exposure misclassification, differential
probsens(matrix(c(45, 94, 257, 945),
                   dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")),
                   nrow = 2, byrow = TRUE),
         type = "exposure",
         reps = 20000,
         seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
         seexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
         spca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
         spexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
         corr.se = .8,
         corr.sp = .8)
# Disease misclassification
probsens(matrix(c(173, 602, 134, 663),
                   dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")),
                   nrow = 2, byrow = TRUE),
         type = "outcome",
         reps = 20000,
         seca.parms = list("uniform", c(.8, 1)),
         spca.parms = list("uniform", c(.8, 1)))
}
