% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power-law.R
\name{power_law}
\alias{power_law}
\title{Taylor's and binary power laws.}
\usage{
power_law(data, log_base = exp(1), ...)
}
\arguments{
\item{data}{A list of \code{intensity} objects (\code{count} or
\code{incidence} objects).}

\item{log_base}{Logarithm base to be used.}

\item{...}{Additional arguments to be passed to other methods.}
}
\value{
A \code{power_law} object.
}
\description{
Assesses the overall degree of heterogeneity in a collection of data sets at
the sampling-unit scale.
}
\details{
The power law describes the relationship between the observed variance of
individuals within a data set (\code{s^2}) and the corresponding variance
under the assumption of no aggregation (\code{s\'^2}). It can be expressed
under its logarithmic form as: \code{log(s^2) = log(a) + b log(Y)}, with:
\itemize{
    \item \code{Y = p} in the case of count data (Taylor's power law).
    \item \code{Y = p(1 - p)} in the case of incidence data (binary power law).
}
\code{p} corresponds to the mean proportion of recorded individuals in case
of incidence data, and the absolute value in case of count data.
}
\examples{
require(magrittr)
my_data <- do.call(c, lapply(citrus_ctv, function(citrus_field) {
   incidence(citrus_field) \%>\%
       clump(unit_size = c(x = 3, y = 3)) \%>\%
       split(by = "t")
}))
# my_data is a list of incidence object, each one corresponding to a given
# time at a given location.
my_power_law <- power_law(my_data)
my_power_law
summary(my_power_law)
plot(my_power_law) # Same as: plot(my_power_law, scale = "log")
plot(my_power_law, scale = "lin")

}
\references{
Taylor LR. 1961. Aggregation, variance and the mean. Nature 189: 732–35.

Hughes G, Madden LV. 1992. Aggregation and incidence of disease. Plant
Pathology 41 (6): 657–660.
\href{http://dx.doi.org/10.1111/j.1365-3059.1992.tb02549.x}{doi:10.1111/j.1365-3059.1992.tb02549.x}

Madden LV, Hughes G, van den Bosch F. 2007. Spatial aspects of epidemics -
III: Patterns of plant disease. In: The study of plant disease epidemics,
235–278. American Phytopathological Society, St Paul, MN.
}
