% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter-utils.R
\name{create_summary_stats}
\alias{create_summary_stats}
\title{Specify reported summary statistics}
\usage{
create_summary_stats(
  mean = NA_real_,
  mean_ci_limits = c(NA_real_, NA_real_),
  mean_ci = NA_real_,
  sd = NA_real_,
  sd_ci_limits = c(NA_real_, NA_real_),
  sd_ci = NA_real_,
  median = NA_real_,
  median_ci_limits = c(NA_real_, NA_real_),
  median_ci = NA_real_,
  dispersion = NA_real_,
  dispersion_ci_limits = c(NA_real_, NA_real_),
  dispersion_ci = NA_real_,
  lower_range = NA_real_,
  upper_range = NA_real_,
  quantiles = NA_real_
)
}
\arguments{
\item{mean}{A \code{numeric} of the mean (expectation) of the probability
distribution.}

\item{mean_ci_limits}{A \code{numeric} vector of length two of the confidence
interval around the mean.}

\item{mean_ci}{A \code{numeric} specifying the confidence interval width,
e.g. \code{95} would be the 95\% CI}

\item{sd}{A \code{numeric} of the standard deviation of the probability
distribution.}

\item{sd_ci_limits}{A \code{numeric} vector of length 2 of the confidence interval
around the standard deviation.}

\item{sd_ci}{A \code{numeric} specifying the confidence interval width,
e.g. \code{95} would be 95\% confidence interval.}

\item{median}{A \code{numeric} of the median of the probability distribution.}

\item{median_ci_limits}{A \code{numeric} vector of length two of the confidence
interval around the median.}

\item{median_ci}{A \code{numeric} specifying the confidence interval width
of the median.}

\item{dispersion}{A \code{numeric} of the dispersion of the probability
distribution. \strong{Important} this is the dispersion for probability
distributions that are not usually parameterised by a dispersion parameter,
for example a lognormal distribution. If a probability distribution is
usually parameterised with a dispersion parameter, e.g. negative binomial
distribution, then this should be considered a parameter and not a summary
statistic and should go in the \code{prob_distribution} argument when
constructing an \verb{<epiparameter>} object with \code{\link[=epiparameter]{epiparameter()}}
(see \code{\link[=create_prob_distribution]{create_prob_distribution()}}).}

\item{dispersion_ci_limits}{A \code{numeric} vector of length 2 of the confidence
interval around the dispersion.}

\item{dispersion_ci}{A \code{numeric} specifying the confidence interval width,
e.g. \code{95} would be 95\% confidence interval.}

\item{lower_range}{The lower range of the data, used to infer the parameters
of the distribution when not provided.}

\item{upper_range}{The upper range of the data, used to infer the parameters
of the distribution when not provided.}

\item{quantiles}{A \code{numeric} vector of the quantiles for the distribution.
If quantiles are not provided a default empty vector with the 2.5th, 5th,
25th, 75th, 95th, 97.5th quantiles are supplied.}
}
\value{
A list of summary statistics. The output list has element names
equal to the function arguments:
\preformatted{
$mean
$mean_ci_limits
$mean_ci
$sd
$sd_ci_limits
$sd_ci
$median
$median_ci_limits
$median_ci
$dispersion
$dispersion_ci_limits
$dispersion_ci
$lower_range
$upper_range
$quantiles
}
}
\description{
A helper function when creating an \verb{<epiparameter>} object to
create a summary statistics list with sensible defaults, type checking
and arguments to help remember which summary statistics can be accepted in
the list.
}
\examples{
# mean and standard deviation
create_summary_stats(mean = 5, sd = 2)

# mean and standard deviation with uncertainty
create_summary_stats(
  mean = 4,
  mean_ci_limits = c(2.1, 5.7),
  mean_ci = 95,
  sd = 0.7,
  sd_ci_limits = c(0.3, 1.1),
  sd_ci = 95
)

# median and range
create_summary_stats(
  median = 5,
  lower_range = 1,
  upper_range = 13
)
}
