test_that("format_item", {
  expect_identical(format_item(5), "5")
  expect_identical(format_item("5"), "5")
  expect_identical(format_item("*"), "*")
  expect_identical(format_item(as.Date("2020-01-01")), "20200101")
  expect_identical(format_item(as.Date("2020-01-01") + 0:1), "20200101,20200102")
  expect_identical(format_item(epirange(201501, 201601)), "201501-201601")
})

test_that("format_list", {
  expect_identical(format_list(5), "5")
  expect_identical(format_list("5"), "5")
  expect_identical(format_list("*"), "*")
  expect_identical(format_list(as.Date("2020-01-01")), "20200101")
  expect_identical(format_list(as.Date("2020-01-01") + 0:1), "20200101,20200102")
  expect_identical(format_list(c(5, 6)), "5,6")
  expect_identical(format_list(c("5", "6")), "5,6")
  expect_identical(format_list(c("*", "*")), "*,*")
  expect_identical(format_list(list(5, 6)), "5,6")
  expect_identical(format_list(list("5", "6")), "5,6")
  expect_identical(format_list(list("*", "*")), "*,*")
})
