% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pub_covid_hosp_facility_lookup}
\alias{pub_covid_hosp_facility_lookup}
\title{COVID hospitalization facility identifiers}
\usage{
pub_covid_hosp_facility_lookup(
  ...,
  state = NULL,
  ccn = NULL,
  city = NULL,
  zip = NULL,
  fips_code = NULL,
  fetch_args = fetch_args_list()
)
}
\arguments{
\item{...}{not used for values, forces later arguments to bind by name}

\item{state}{string. A two-letter character state abbreviation.}

\item{ccn}{string. A facility CMS certification number.}

\item{city}{string. A city name.}

\item{zip}{string. A 5-digit zip code.}

\item{fips_code}{string. A 5-digit fips county code, zero-padded.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
API docs:
\url{https://cmu-delphi.github.io/delphi-epidata/api/covid_hosp_facility_lookup.html}

Obtains unique identifiers and other metadata for COVID hospitalization
facilities of interest. This is a companion endpoint to the
\code{\link[=pub_covid_hosp_facility]{pub_covid_hosp_facility()}} endpoint.
}
\details{
Only one location argument needs to be specified.
Combinations of the arguments are not currently supported.
}
\examples{
\dontrun{
pub_covid_hosp_facility_lookup(state = "fl")
pub_covid_hosp_facility_lookup(city = "southlake")
}
}
\seealso{
\code{\link[=pub_covid_hosp_facility]{pub_covid_hosp_facility()}}
}
\keyword{endpoint}
