% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{envvar_get_integer}
\alias{envvar_get_integer}
\alias{envvar_get_numeric}
\alias{envvar_get_logical}
\alias{envvar_get_version}
\alias{envvar_get_date}
\alias{envvar_get_datetime}
\title{Get the value of an environment variable as a particular type}
\usage{
envvar_get_integer(x, default = NULL, validate = NULL)

envvar_get_numeric(x, default = NULL, validate = NULL)

envvar_get_logical(x, default = NULL, validate = NULL)

envvar_get_version(x, default = NULL, validate = NULL)

envvar_get_date(x, default = NULL, validate = NULL, ...)

envvar_get_datetime(x, default = NULL, validate = NULL, ...)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{default}{Optional default value if the environment variable is not set}

\item{validate}{Optional function that checks a value for validity}

\item{...}{Additional arguments passed to \link[lubridate:as_date]{lubridate::as_date} for
\code{envvar_get_date()} or \link[lubridate:as_date]{lubridate::as_datetime} for \code{envvar_get_datetime()}}
}
\value{
A scalar object
}
\description{
\code{envvar_get_integer()} reads environment variables with integer
values (e.g., \code{15}, \code{0}, \code{-1})

\code{envvar_get_numeric()} reads environment variables with numeric
values (e.g., \code{100.12}, \code{-31})

\code{envvar_get_logical()} reads environment variables with logical
values (e.g., \code{TRUE}, \code{1}, \code{"T"})

\code{envvar_get_version} reads environment variables with semantic
version numbers (e.g., \verb{4.3.1})

\code{envvar_get_date()} reads environment variables with date values
(e.g., \code{"2023-01-02"})

\code{envvar_get_date()} reads environment variables with date-time
values (e.g., \code{"2023-01-02 01:23:45 UTC"} or 1697037804)
}
\examples{

# Get and use an integer value
envvar_set("MYNUMBER" = 12)
envvar_get_integer("MYNUMBER") + 5

# Get and use a numeric value
envvar_set("MYNUMBER" = 12.34)
envvar_get_numeric("MYNUMBER") + 5

# Check a logical value
isTRUE(envvar_get_logical("RSTUDIO_CLI_HYPERLINKS", default = FALSE))

# Get an IP address value and ensure that it is IPv4
envvar_set("MY_VER" = "4.3.1")
envvar_get_version("MY_VER", validate = \(x) x > as.numeric_version("4.3"))
# Get a date and make sure it's in the future
envvar_set("LAUNCH_DATE" = "2024-08-08")
envvar_get_date("LAUNCH_DATE", validate = \(x) x > Sys.Date())
}
