% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_envstat.R
\name{use_envstat}
\alias{use_envstat}
\title{Create a new skeleton configuration file}
\usage{
use_envstat(filepath = "~/.envstat", source = NULL)
}
\arguments{
\item{filepath}{path to the config file}

\item{source}{customise the source of the example config file}
}
\value{
TRUE/FALSE invisibly to indicate success/failure
}
\description{
Create a new skeleton configuration file
}
\examples{
\dontrun{
# By default envstat uses a config file in your home directory
envstat::use_envstat()

# But you can tell it to use a different config file if you prefer
envstat::use_envstat(filepath = "/tmp/config.yml")

# During normal operation use_envstat uses a default config file that ships
# with the package, but you can specify your own if you have one. This can
# be useful in settings such as multi-user server deployments of R, as many
# users could use the same base configuration file and personalise it for
# their own specific use case.
envstat::use_envstat(source = "/shared/corp_envstat_conf.yml")
}
}
