% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.glm.R
\name{enrich.glm}
\alias{enrich.glm}
\title{Enrich objects of class \code{\link{glm}}}
\usage{
\method{enrich}{glm}(object, with = "all", ...)
}
\arguments{
\item{object}{an object of class glm}

\item{with}{a character vector with the names of the components to
enrich \code{object} with}

\item{...}{extra arguments to be passed to the
\code{compute_*} functions}
}
\value{
The object \code{object} of class \code{\link{glm}} with extra
components. \code{get_enrichment_options.glm()} returns the
components and their descriptions.
}
\description{
Enrich objects of class \code{\link{glm}} with any or all of a set
auxiliary functions, the maximum likelihood estimate of the
dispersion parameter, the expected or observed information at the
maximum likelihood estimator, and the first term in the expansion
of the bias of the maximum likelihood estimator.
}
\details{
The auxiliary functions consist of the score functions, the
expected or observed information and the first-order bias of the
maximum likelihood estimator as functions of the model parameters.
}
\examples{
\dontrun{

## Reproduce left plot in Figure 4.1 in Kosimdis (2007)
## (see http://www.ucl.ac.uk/~ucakiko/files/ikosmidis_thesis.pdf)
mod <- glm(1 ~ 1, weights = 10, family = binomial())
enriched_mod <- enrich(mod, with = "auxiliary functions")
biasfun <- enriched_mod$auxiliary_functions$bias
probabilities <- seq(1e-02, 1 - 1e-02, length = 100)
biases <- Vectorize(biasfun)(qlogis(probabilities))[1,]
plot(probabilities, biases, type = "l", ylim = c(-0.5, 0.5),
     xlab = expression(pi), ylab = "first-order bias")
abline(h = 0, lty = 2)
title("First-order bias of the MLE of the log-odds", sub = "m = 10")
}
}

