% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\name{arrange_replies}
\alias{arrange_replies}
\title{Arrange topics based on number of replies}
\usage{
arrange_replies(
  topics,
  by_theme = TRUE,
  by_date = c("month_year", "year", "all")
)
}
\arguments{
\item{topics}{A tibble of topics by theme from \strong{en-net forum} produced
through a call to \code{\link[=get_themes_topics]{get_themes_topics()}}.}

\item{by_theme}{Logical. Should topics be grouped by theme?
Default is \emph{TRUE}.}

\item{by_date}{Should topics be grouped by month of the year or just by
year? Default is to group by month of the year.}
}
\value{
A tibble of topic views by theme and by specified date format
arranged in descending order
}
\description{
Arrange topics based on number of replies
}
\examples{
library(magrittr)
ennet_topics \%>\% arrange_replies()

}
\author{
Ernest Guevarra
}
