% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\name{count_topics_author}
\alias{count_topics_author}
\alias{count_topics_author_time}
\title{Count number of questions/topics posted on en-net by author}
\usage{
count_topics_author(topics = get_themes_topics(), .sort = TRUE)

count_topics_author_time(
  topics = get_themes_topics(),
  by_time = c("day", "week", "month", "year"),
  .sort = TRUE
)
}
\arguments{
\item{topics}{A tibble of topics by theme, by author, and by posting date
from \strong{en-net} forum produced through a call to \code{\link[=get_themes_topics]{get_themes_topics()}}}

\item{.sort}{Logical. Should output be sorted by count frequencies? Default
is \emph{TRUE}}

\item{by_time}{Should topics be counted by day, by week, by month or by year?
Default is to count by day.}
}
\value{
A tibble of topic counts by specified grouping
}
\description{
Count number of questions/topics posted on en-net by author
}
\examples{
## Get counts of topics by author
count_topics_author(topics = ennet_topics)

## Get counts of authors by author and by time
count_topics_author_time(topics = ennet_topics)

}
\author{
Ernest Guevarra
}
