% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enerscape_internals.R
\name{.calc_cycling_cond}
\alias{.calc_cycling_cond}
\title{Compute conductance for a cyclist}
\usage{
.calc_cycling_cond(height, slope, m, v, work_in_kcal = TRUE, j_to_kcal = 4184)
}
\arguments{
\item{height}{height transition matrix.}

\item{slope}{slope transition matrix.}

\item{m}{species body mass (kg).}

\item{v}{speed of cyclist.}

\item{work_in_kcal}{if work should be expressed in kilocalories.}

\item{j_to_kcal}{joules to kilocalories conversion constant.}
}
\value{
A transition layer with values the energy cost of movement between
  cells (J or kcal).
}
\description{
Internal function for enerscape - calculate work.
}
\details{
Internal function of enerscape, don't call directly. This assumes no
  wind, a bike of 7 kg, optimal pedal frequency, and constant mechanical
  efficiency of 25%.
}
