% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encoding}
\alias{encoding}
\alias{all_utf8}
\title{Encoding information}
\usage{
encoding(x)

all_utf8(x)
}
\arguments{
\item{x}{A character vector.}
}
\description{
The \code{encoding} function returns \code{"ASCII"} if the entire value
consists of ASCII symbols only, and works identically to
\code{\link[=Encoding]{Encoding()}} otherwise.
The \code{all_utf8} function is an efficient variant of
\code{all(encoding(x) \%in\% c("ASCII", "UTF-8"))}.
}
\examples{
encoding("a")
encoding("\u00fc")
all_utf8(enc2utf8(c("a", "\u00fc")))

# Platform-dependent:
all_utf8(enc2native(c("a", "\u00fc")))
}
