% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.orient.R
\name{set.orient}
\alias{set.orient}
\title{Globally reorients matrices}
\usage{
set.orient(x = c("rc", "school"))
}
\arguments{
\item{x}{The school determining the orientation}
}
\description{
Changes the orientation of output matrices.
}
\details{
The enaR package as a whole, and the broader network
analysis community, assumes a row to column orientation; thus, the
default orientation for the package is row to column (DEFAULT =
'rc'). However, functions from the Patten school were orignially
developed to conduct calculations and produce output in the column
to row orientation. In order to facilitate the use of these
functions, we also provide the option for users to return output in
the orientation of the "school" (i.e. Patten results will be column
to row oriented) by setting the global orientation to "school"
using this fuction.  Orientation setting. If "rc" (DEFAULT), all
matrix output will be returned in row (=input) to column (=output)
orientation, regardless of school. If "school", then output
matrices from functions from particular ENA schools will be
oriented as expected in that school (i.e. Patten = column-row or
Ulanowicz = row-column). Note, that all functions in the enaR
package expect input matrices to be oriented row-column.
}
\examples{

original.orientation = get.orient()
original.orientation
set.orient("school")
get.orient()
set.orient("rc")
get.orient()
set.orient(original.orientation)

}
\seealso{
\code{\link{get.orient}}
}
\author{
Matthew K. Lau Stuart R. Borrett
}
