% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.trackdata.R
\name{rbind.trackdata}
\alias{rbind}
\alias{rbind.trackdata}
\title{A method of the generic function rbind for objects of class trackdata}
\usage{
rbind.trackdata(...)
}
\arguments{
\item{\dots}{track data objects}
}
\value{
A track data object with the same \$index and \$ftime values of the
source track data objects and with \$data that includes all columns of
\$data of the source track data objects.
}
\description{
Different track data objects from one segment list are bound by combining
the \$data columns of the track data object by rows.  Track data objects
are created by \code{\link{get_trackdata}}.
}
\details{
All track data objects have to be track data of the same segment list.
Thus \$index and \$ftime values have to be identically for all track data
objects.  The number of columns of the track data objects must match. Thus
a track data object of more than one formant and single columned F0 track
data object can not be rbind()ed.
}
\examples{

   data(vowlax)
   
   #segment list vowlax - first segment only 
   vowlax[1,]
   
   #F0 track data object for vowlax - first segment only 
   vowlax.fund[1]
   
   #rms track data object for vowlax - first segment only 
   vowlax.rms[1]
   
   #now combine both track data objects
   fund.rms.lax = rbind(vowlax.fund[1:10,], vowlax.rms[1:10,])
 
   #the combined track data object
   #The first ten rows in \\$data keep vowlax.fund data, the 11th to last row keeps vowlax.rms data 
   fund.rms.lax
   


}
\author{
Jonathan Harrington
}
\seealso{
\code{\link{rbind}} \code{\link{cbind.trackdata}}
\code{\link{trackdata}} \code{\link{get_trackdata}}
}
\keyword{methods}

