% Generated by roxygen2 (4.0.1): do not edit by hand
\name{evaluate.modeling}
\alias{evaluate.modeling}
\title{Performance estimation of modeling procedures}
\usage{
evaluate.modeling(proc, x, y, ..., .save = list(fit = FALSE, pred = TRUE, vimp
  = FALSE, tuning = TRUE), .verbose = TRUE)
}
\arguments{
\item{proc}{modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling.procedure}}.}

\item{x}{Dataset, observations as rows and descriptors as columns.}

\item{y}{Response vector.}

\item{...}{Sent to \code{\link{tune}} and \code{\link{batch.model}}.}

\item{.save}{See \code{\link{batch.model}}.}

\item{.verbose}{Whether to print an activity log.}
}
\value{
A list of fitted models.
}
\description{
This function performs the important task of evaluating the performance of
a modeling procedure with resampling, including tuning and pre-processing
to not bias the results by information leakage.
}
\examples{
proc <- modeling.procedure("lda")
cv <- resample("crossval", y=iris$Species, nfold=5, nrep=3)
perf <- evaluate.modeling(proc, x=iris[-5], y=iris$Species, resample=cv)
err <- subtree(perf, TRUE, "error")
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling.procedure}},
  \code{\link{fit}}, \code{\link{tune}}
  \code{\link[=predict.modeling.procedure]{predict}}, \code{\link{vimp}}
}

